from django.contrib.auth.models import User
from django.db import models


class UserRole(models.Model):
    user = models.ForeignKey(
        User,
        on_delete=models.PROTECT
    )
    group = models.CharField(
        verbose_name='Ролевая группа',
        max_length=32,
    )
    role = models.CharField(
        verbose_name='Название роли',
        max_length=32
    )
    agency = models.ForeignKey(
        to='Company',
        on_delete=models.PROTECT,
        null=True,
        default=None
    )

    class Meta:
        verbose_name = 'Роль пользователя'
        verbose_name_plural = 'Роли пользователя'

        indexes = [
            models.Index(fields=['group']),
            models.Index(fields=['role'])
        ]
