from rest_framework import permissions


class IsRepresentative(permissions.BasePermission):
    """
    Проверяем, что к нам пришли с запросом от представителя агентства
    для правки/добавления агентств, которые он представляет
    """
    def has_object_permission(self, request, view, obj):
        if request.method in permissions.SAFE_METHODS:
            return True

        external_login = request.headers.get('x-ya-external-login')

        if not external_login:
            return False

        return obj.representatives.filter(username=external_login).count() > 0
