from rest_framework import serializers

from commerce.adv_backend.backend.models import CompanyOffice, City

from .city import CitySerializer


class CompanyOfficeSerializer(serializers.ModelSerializer):
    city = CitySerializer()

    class Meta:
        model = CompanyOffice
        fields = (
            'id',
            'address',
            'city',
            'email',
            'is_main',
            'latitude',
            'longitude',
            'map',
            'map_zoom',
            'phone'
        )
        depth = 1


class CompanyOfficeWriteSerializer(serializers.ModelSerializer):
    city = serializers.SlugRelatedField(
        queryset=City.objects.all(),
        slug_field='geo_id',
        required=True
    )

    class Meta:
        model = CompanyOffice
        fields = (
            'id',
            'address',
            'city',
            'email',
            'is_main',
            'latitude',
            'longitude',
            'map',
            'map_zoom',
            'phone'
        )
        depth = 1
