from rest_framework import serializers

from ..models import CompanyRepresentative, ExternalUser


class CompanyRepresentativeSerializer(serializers.BaseSerializer):
    def to_internal_value(self, data):
        username = data.get('username')
        is_main = data.get('is_main', True)

        if not username:
            raise serializers.ValidationError({
                'username': 'This field is required.'
            })

        return {
            'username': username,
            'is_main': is_main
        }

    def to_representation(self, instance):
        return {
            'username': instance.representative.username,
            'is_main': instance.is_main
        }

    def create(self, validated_data):
        username = validated_data.pop('username')
        user = ExternalUser.objects.get_or_create(username=username)

        CompanyRepresentative.objects.create(representative=user, **validated_data)

    def update(self, instance, validated_data):
        is_main = validated_data.get('is_main', instance.is_main)

        username = validated_data.get('username', instance.representative.username)
        user = ExternalUser.objects.get_or_create(username=username)

        instance.representative = user
        instance.is_main = is_main
        instance.save()

        return instance
