from django.urls import path

from . import views

app_name = 'backend'

urlpatterns = [
    path('companies/', views.CompanyViewSet.as_view({
        'get': 'list',
        'post': 'create'
    }), name='companies'),
    path('companies/certificates/', views.CompaniesFormView.as_view(), name='companies-certificates'),
    path('companies/download/', views.CompaniesDownloadView.as_view(), name='companies-download'),
    path('companies/filters/', views.CompaniesFilters.as_view({'get': 'list'}), name='companies-filters'),
    path('companies/slugs/', views.CompaniesSlugsList.as_view({'get': 'list'}), name='companies-slugs'),
    path('companies/<slug:slug>/', views.CompanyViewSet.as_view({
        'get': 'retrieve',
        'patch': 'partial_update'
    }), name='companies-company'),
    path('external-user/companies/', views.ExternalUserCompaniesList.as_view({
        'get': 'list'
    }), name='external-user-companies')
]
