from django.core.exceptions import ValidationError
from django.utils.deconstruct import deconstructible


@deconstructible
class FileValidator:
    message = "Тип файла %(content_type)s не поддерживается."
    code = '400_IMT'

    def __init__(self, content_types=None):
        self.content_types = content_types

    def __call__(self, data):
        if self.content_types:
            content_type = data.content_type

            if content_type not in self.content_types:
                params = {'content_type': content_type}
                raise ValidationError(self.message, code=self.code, params=params)

    def __eq__(self, other):
        return (
            isinstance(other, FileValidator) and
            other.content_types == self.content_types and
            other.message == self.message and
            other.code == self.code
        )
