import yenv

from django.conf import settings
from django.contrib import admin
from django.urls import include, path

from . import views
from ..backend.utils import static


urlpatterns = [
    path('admin/', admin.site.urls),
    path('idm/', include('django_idm_api.urls')),
    path('ping/', views.ping, name='ping'),
    path('v1/', include('commerce.adv_backend.backend.urls', namespace='v1'))
]

if yenv.type == 'development':
    import debug_toolbar

    urlpatterns = [
        path('__debug__/', include(debug_toolbar.urls)),
    ] + urlpatterns

urlpatterns += static(
    settings.STATIC_URL,
    document_root=settings.STATIC_ROOT,
)
