PY3TEST(adv-tests)

OWNER(g:commerce)

PEERDIR(
    contrib/python/pytest-django
    contrib/python/factory-boy

    library/python/testing/yatest_common

    commerce/adv_backend
)

# Иначе будет warning из стороннего фреймворка
NO_CHECK_IMPORTS(
    rest_framework.authtoken.*
)

ENV(DJANGO_SETTINGS_MODULE=commerce.adv_backend.tests.settings)

ENV(USER=volozh)

ENV(DATABASE_NAME=adv)
ENV(DATABASE_USER=adv)

INCLUDE(${ARCADIA_ROOT}/commerce/adv_backend/recipes/postgresql/recipe.inc)

DATA(
    arcadia/commerce/adv_backend/tests/backend/fixtures/add_list.csv
    arcadia/commerce/adv_backend/tests/backend/fixtures/remove_list.csv
)

PY_SRCS(
    factory/data/__init__.py
    factory/data/city.py
    factory/data/company_certificate.py
    factory/data/country.py
    factory/data/region.py

    factory/__init__.py
    factory/abstract/__init__.py
    factory/abstract/moderation_model.py
    factory/abstract/translation_model.py
    factory/city.py
    factory/company.py
    factory/company_certificate.py
    factory/company_office.py
    factory/company_representative.py
    factory/country.py
    factory/external_user.py
    factory/region.py
    factory/tld.py
    factory/user.py
    factory/userrole.py

    backend/utils/__init__.py
    backend/utils/create_user.py
)

TEST_SRCS(
    project/views/tests_ping.py

    backend/views/company/test_companies.py
    backend/views/company/test_companies_certificates.py
    backend/views/company/test_companies_company.py
    backend/views/company/test_companies_download.py
    backend/views/company/test_external_user_companies.py
    backend/views/company/test_filters.py
    backend/views/company/test_slugs.py

    backend/validators/test_materials_url.py
)

SIZE(MEDIUM)

PY_SRCS(
    settings.py
)

END()
