PY3_LIBRARY()

OWNER(g:commerce)

PEERDIR(
    contrib/python/django-debug-toolbar
    contrib/python/django-filter
    contrib/python/django-modeltranslation
    contrib/python/django-moderation
    contrib/python/django/django-2.2
    contrib/python/djangorestframework
    contrib/python/djangorestframework-camel-case
    contrib/python/gunicorn
    contrib/python/html2text
    contrib/python/ipython
    contrib/python/python-slugify
    contrib/python/requests
    library/python/yenv

    library/python/django
    library/python/django_pgaas
    library/python/django-idm-api
    library/python/granular_settings
    library/python/python-django-yauth
    library/python/startrek_python_client

    commerce/adv_backend/backend/migrations
)

PY_SRCS(
    backend/__init__.py
    backend/admin.py
    backend/apps.py
    backend/urls.py
    backend/moderator.py
    backend/translation.py

    backend/decorators/__init__.py
    backend/decorators/drf.py
    backend/decorators/translations.py

    backend/libs/__init__.py
    backend/libs/startrek.py

    backend/management/commands/b2d.py
    backend/management/commands/createrolesuperuser.py
    backend/management/commands/migrator/bunker.py
    backend/management/commands/migrator/geobase.py
    backend/management/commands/migrator/html.py
    backend/management/commands/migrator/migrate.py
    backend/management/commands/migrator/models.py
    backend/management/commands/migrator/session.py

    backend/middlewares/__init__.py
    backend/middlewares/auth.py
    backend/middlewares/locale_middleware.py

    backend/mixins/__init__.py
    backend/mixins/admin_permission.py
    backend/mixins/companies_filters.py
    backend/mixins/ordering.py
    backend/mixins/translation_required.py
    backend/mixins/view_permissions.py

    backend/models/__init__.py
    backend/models/abstract/__init__.py
    backend/models/abstract/enum_model.py
    backend/models/abstract/geo_model.py
    backend/models/abstract/moderated_model.py
    backend/models/city.py
    backend/models/company.py
    backend/models/company_certificate.py
    backend/models/company_office.py
    backend/models/company_representative.py
    backend/models/company_type.py
    backend/models/country.py
    backend/models/external_user.py
    backend/models/region.py
    backend/models/tld.py
    backend/models/user_role.py

    backend/permissions/__init__.py
    backend/permissions/hooks.py
    backend/permissions/is_representative.py

    backend/serializers/__init__.py
    backend/serializers/city.py
    backend/serializers/company.py
    backend/serializers/company_certificate.py
    backend/serializers/company_office.py
    backend/serializers/company_representative.py
    backend/serializers/company_type.py
    backend/serializers/country.py
    backend/serializers/external_user.py

    backend/types/__init__.py
    backend/types/model.py

    backend/utils/__init__.py
    backend/utils/admin_links.py
    backend/utils/filters.py
    backend/utils/reverse.py
    backend/utils/serializers.py
    backend/utils/translations.py
    backend/utils/urls.py

    backend/validators/__init__.py
    backend/validators/file.py
    backend/validators/materials_url.py

    backend/views/__init__.py
    backend/views/company.py

    project/settings.py
    project/urls.py
    project/views.py
)

RESOURCE_FILES(
    PREFIX commerce/adv_backend/

    backend/templates/400.html
    backend/templates/403.html
    backend/templates/company/download.html
    backend/templates/company/form.html
    backend/templates/company/form_success.html
    backend/templates/message_moderator.txt
    backend/templates/subject_moderator.txt

    project/settings/000-debug.conf
    project/settings/000-debug.conf.development
    project/settings/001-base.conf
    project/settings/001-base.conf.development
    project/settings/001-base.conf.production
    project/settings/002-security.conf
    project/settings/002-security.conf.development
    project/settings/003-apps.conf
    project/settings/003-apps.conf.development
    project/settings/004-middlewares.conf
    project/settings/004-middlewares.conf.development
    project/settings/005-databases.conf
    project/settings/006-yauth.conf
    project/settings/006-yauth.conf.development
    project/settings/006-yauth.conf.production
    project/settings/007-idm.conf
    project/settings/008-bunker.conf
    project/settings/008-bunker.conf.production
    project/settings/009-geobase.conf
    project/settings/010-startrek.conf
    project/settings/010-startrek.conf.production
    project/settings/011-companies-form.conf
    project/settings/012-permissions.conf
)

END()

RECURSE(
    recipes

    project/manage
    project/uwsgi
)

RECURSE_FOR_TESTS(tests)
