package cache

import (
	"sync"

	"a.yandex-team.ru/commerce/libs/goblogs"
)

type localCache struct {
	*sync.Map
}

func NewLocalCache() Cache {
	return &localCache{new(sync.Map)}
}

func (c *localCache) get(params ...string) (interface{}, bool) {
	key := GetCacheKey(params...)

	return c.Load(key)
}

func (c *localCache) set(value interface{}, params ...string) error {
	key := GetCacheKey(params...)

	c.Store(key, value)

	return nil
}

func (c *localCache) GetBlog(slug, language string) (blog *goblogs.Blog, ok bool) {
	if value, inCache := c.get(slug, language, blogInfoKey); inCache {
		blog, ok = value.(*goblogs.Blog)
	}

	return
}

func (c *localCache) SetBlog(slug, language string, blog *goblogs.Blog) error {
	return c.set(blog, slug, language, blogInfoKey)
}

func (c *localCache) GetBlogCategories(slug, language string) (categories []goblogs.Category, ok bool) {
	if value, inCache := c.get(slug, language, blogCategoriesKey); inCache {
		categories, ok = value.([]goblogs.Category)
	}

	return
}

func (c *localCache) SetBlogCategories(slug, language string, categories []goblogs.Category) error {
	return c.set(categories, slug, language, blogCategoriesKey)
}

func (c *localCache) GetBlogPosts(slug, language string) (posts []goblogs.Post, ok bool) {
	if value, inCache := c.get(slug, language, blogPostsKey); inCache {
		posts, ok = value.([]goblogs.Post)
	}

	return
}

func (c *localCache) SetBlogPosts(slug, language string, posts []goblogs.Post) error {
	return c.set(posts, slug, language, blogPostsKey)
}

func (c *localCache) GetBlogTags(slug, language string) (tags []goblogs.Tag, ok bool) {
	if value, inCache := c.get(slug, language, blogTagsKey); inCache {
		tags, ok = value.([]goblogs.Tag)
	}

	return
}

func (c *localCache) SetBlogTags(slug, language string, tags []goblogs.Tag) error {
	return c.set(tags, slug, language, blogTagsKey)
}

func (c *localCache) GetPost(blogSlug, language, slug string) (post *goblogs.Post, ok bool) {
	if value, inCache := c.get(blogSlug, language, slug, postInfoKey); inCache {
		post, ok = value.(*goblogs.Post)
	}

	return
}

func (c *localCache) SetPost(blogSlug, language, slug string, post *goblogs.Post) error {
	return c.set(post, blogSlug, language, slug, postInfoKey)
}

func (c *localCache) GetPostComments(blogSlug, language, slug string) (comments []goblogs.Comment, ok bool) {
	if value, inCache := c.get(blogSlug, language, slug, postCommentsKey); inCache {
		comments, ok = value.([]goblogs.Comment)
	}

	return
}

func (c *localCache) SetPostComments(blogSlug, language, slug string, comments []goblogs.Comment) error {
	return c.set(comments, blogSlug, language, slug, postCommentsKey)
}

func (c *localCache) GetPostRelatedArticles(blogSlug, language, slug string) (relatedArticles []goblogs.RelatedArticle, ok bool) {
	if value, inCache := c.get(blogSlug, language, slug, postRelatedArticlesKey); inCache {
		relatedArticles, ok = value.([]goblogs.RelatedArticle)
	}

	return
}

func (c *localCache) SetPostRelatedArticles(blogSlug, language, slug string, relatedArticles []goblogs.RelatedArticle) error {
	return c.set(relatedArticles, blogSlug, language, slug, postRelatedArticlesKey)
}

func (c *localCache) GetBlogsStatus() BlogsStatus {
	value, inCache := c.get(blogsStatusKey)

	if !inCache {
		return BlogsOK
	}

	return value.(BlogsStatus)
}

func (c *localCache) SetBlogsStatus(value BlogsStatus) error {
	return c.set(value, blogsStatusKey)
}

func (c *localCache) Lock(key string) error {
	return nil
}

func (c *localCache) Unlock(key string) error {
	return nil
}
