package config

const (
	configFileName = "config.yml"
)

var Values = Config{
	Port: 8000,

	Blogs: BlogsConfig{
		BaseURL:    "http://yablogs-api-test.common.yandex.ru/v1",
		RetryCount: 3,

		RU: []string{"adv-news"},
		EN: []string{"adv-news-cn", "adv-news-com"},
		TR: []string{"adv-news-com-tr"},
	},

	Cache: CacheConfig{
		Type: "local",

		WarmUpConcurrencyLimit: 10,

		WarmUpBackOff: 10,
		WarmUpPeriod:  60,
	},

	Logger: LoggerConfig{
		Level: "debug",
	},

	Redis: RedisConfig{
		Addresses: []string{"localhost:6379"},
	},
}

type Config struct {
	Port int `config:"port"`

	Blogs  BlogsConfig
	Cache  CacheConfig
	Logger LoggerConfig
	Redis  RedisConfig
}

type BlogsConfig struct {
	BaseURL    string `config:"blogs-base-url" yaml:"base-url"`
	RetryCount int    `config:"blogs-retry-count" yaml:"retry-count"`

	RU []string `config:"blogs-ru"`
	EN []string `config:"blogs-en"`
	TR []string `config:"blogs-tr"`
}

type CacheConfig struct {
	Type    string `config:"cache-type"`
	Version string `config:"cache-version"`

	WarmUpConcurrencyLimit uint8 `config:"cache-concurrency-limit"`

	WarmUpBackOff uint64 `config:"cache-backoff"`
	WarmUpPeriod  uint64 `config:"cache-period"`
}

type LoggerConfig struct {
	Level string `config:"logger-level"`
}

type RedisConfig struct {
	Addresses  []string `config:"redis-addresses"`
	Password   string   `config:"redis-password"`
	MasterName string   `config:"redis-master-name"`

	TTL int64 `config:"redis-ttl"`
}
