package config

import (
	"context"
	"os"

	"github.com/heetch/confita"
	"github.com/heetch/confita/backend"
	"github.com/heetch/confita/backend/env"
	"github.com/heetch/confita/backend/file"
)

func init() {
	backends := []backend.Backend{
		env.NewBackend(),
	}

	if _, err := os.Stat(configFileName); !os.IsNotExist(err) {
		backends = append(backends, file.NewBackend(configFileName))
	}

	loader := confita.NewLoader(backends...)

	if err := loader.Load(context.Background(), &Values); err != nil {
		panic("failed to load config")
	}
}
