package controllers

import (
	"net/http"
	"os"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/commerce/blogs_pumpkin/cache"
	"a.yandex-team.ru/commerce/blogs_pumpkin/context"
)

func Ping(c echo.Context) error {
	return c.String(http.StatusOK, "pong")
}

func PingBlogs(c echo.Context) error {
	cc := c.(context.Context)

	if os.Getenv("FORCE_DEGRADE") == "1" || cc.Cache().GetBlogsStatus() != cache.BlogsOK {
		return c.String(http.StatusInternalServerError, "Happy Halloween!")
	} else {
		return c.String(http.StatusOK, "pong")
	}
}
