package controllers

import (
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/commerce/blogs_pumpkin/context"
)

const (
	postNotFoundMessage = `{"message":"post not found","internalCode":"404_PNF"}`
)

func Post(c echo.Context) error {
	cc := c.(context.Context)

	blogSlug, language, slug := getPostParams(cc)

	if post, ok := cc.Cache().GetPost(blogSlug, language, slug); ok {
		return cc.JSON(http.StatusOK, post)
	} else {
		return cc.String(http.StatusNotFound, postNotFoundMessage)
	}
}

func PostComments(c echo.Context) error {
	cc := c.(context.Context)

	blogSlug, language, slug := getPostParams(cc)

	if comments, ok := cc.Cache().GetPostComments(blogSlug, language, slug); ok {
		return cc.JSON(http.StatusOK, comments)
	} else {
		return cc.String(http.StatusNotFound, postNotFoundMessage)
	}
}

func PostRelatedArticles(c echo.Context) error {
	cc := c.(context.Context)

	blogSlug, language, slug := getPostParams(cc)

	if relatedArticles, ok := cc.Cache().GetPostRelatedArticles(blogSlug, language, slug); ok {
		return cc.JSON(http.StatusOK, relatedArticles)
	} else {
		return cc.String(http.StatusNotFound, postNotFoundMessage)
	}
}

func getPostParams(cc context.Context) (blogSlug, language, slug string) {
	blogSlug, language = getBlogParams(cc)
	slug = cc.Param("post")

	return
}
