package middlewares

import (
	"net/url"
	"os"
	"strings"

	"github.com/labstack/echo/v4"
	"github.com/labstack/echo/v4/middleware"

	"a.yandex-team.ru/commerce/blogs_pumpkin/cache"
	"a.yandex-team.ru/commerce/blogs_pumpkin/config"
	"a.yandex-team.ru/commerce/blogs_pumpkin/context"
)

var (
	BlogsProxy = NewProxy(strings.TrimRight(config.Values.Blogs.BaseURL, "/v1"))
)

func NewProxy(baseURL string) echo.MiddlewareFunc {
	proxyURL, err := url.Parse(baseURL)

	if err != nil {
		panic(err)
	}

	targets := []*middleware.ProxyTarget{{URL: proxyURL}}
	balancer := middleware.NewRoundRobinBalancer(targets)
	proxy := middleware.Proxy(balancer)

	return func(next echo.HandlerFunc) echo.HandlerFunc {
		return func(c echo.Context) error {
			c.Request().Host = proxyURL.Host

			return proxy(next)(c)
		}
	}
}

func NotDeadBlogsProxy(next echo.HandlerFunc) echo.HandlerFunc {
	return func(c echo.Context) error {
		cc := c.(context.Context)

		if os.Getenv("FORCE_DEGRADE") == "1" || cc.Cache().GetBlogsStatus() != cache.BlogsOK {
			cc.Response().Header().Set("X-Is-Pumpkin-Response", "1")

			return next(cc)
		}

		return BlogsProxy(next)(cc)
	}
}
