package router

import (
	"github.com/labstack/echo/v4"
	"github.com/labstack/echo/v4/middleware"

	"a.yandex-team.ru/commerce/blogs_pumpkin/controllers"
	"a.yandex-team.ru/commerce/blogs_pumpkin/middlewares"
)

func Load() *echo.Echo {
	e := echo.New()

	e.HideBanner = true

	e.Use(middleware.Logger())
	e.Use(middleware.Recover())
	e.Use(middlewares.Context)

	e.GET("/ping", controllers.Ping)
	e.GET("/ping-blogs", controllers.PingBlogs)

	g := e.Group("/v1")
	{
		/* can not cache */
		g.Group("/user/activity", middlewares.BlogsProxy)
		g.Group("/comment", middlewares.BlogsProxy)
		g.Group("/complaint", middlewares.BlogsProxy)

		/* proxy, but degrade by necessity */
		g.GET("/posts/:blog", controllers.BlogPosts, middlewares.NotDeadBlogsProxy)
		g.GET("/posts/archive/:blog", controllers.BlogPosts, middlewares.NotDeadBlogsProxy)
		g.GET("/posts/custom/:blog", controllers.BlogPostsCustom, middlewares.NotDeadBlogsProxy)
		g.GET("/post/:blog/:post", controllers.Post, middlewares.NotDeadBlogsProxy)
		g.GET("/comments/all/:blog/:post", controllers.PostComments, middlewares.NotDeadBlogsProxy)
		g.GET("/post/related/:blog/:post", controllers.PostRelatedArticles, middlewares.NotDeadBlogsProxy)

		/* cache forever with updating in background */
		g.GET("/:blog", controllers.Blog)
		g.GET("/categories/all/:blog", controllers.BlogCategories)
		g.GET("/tags/all/:blog", controllers.BlogTags)
		g.GET("/tag/:blog/:tag", controllers.BlogTag)
	}

	return e
}
