'use strict';

const assert = require('helpers/assert');
const _ = require('lodash');

class BaseAccessControl {
    constructor(state) {
        this._uid = _.get(state, 'user.uid.value');
        this._login = _.get(state, 'user.login');
        this._normalizedLogin = _.get(state, 'user.attributes.1008');
        this._authType = _.get(state, 'authType');
    }

    get uid() {
        return this._uid;
    }

    get login() {
        return this._login;
    }

    get authType() {
        return this._authType;
    }

    get normalizedLogin() {
        return this._normalizedLogin;
    }

    authorizationRequired() {
        assert(this.uid, 401, 'User not authorized', 'UNA');
    }
}

module.exports = BaseAccessControl;
