'use strict';

const BaseAccessControl = require('accessControl/base');
const assert = require('helpers/assert');
const { token } = require('yandex-config');

class CertificateAccessControl extends BaseAccessControl {
    hasAccessForFindCertificate(certId, lastname) {
        assert.isNumber(certId, 400, 'Certificate id is invalid', 'CII', { certId });

        assert(lastname, 400, 'Lastname is empty', 'LNE');

        assert(!/.*[;:".\\]+.*/.test(lastname), 400, 'Lastname contains invalid characters', 'LIC');
    }

    hasAccessForFindAllCertificates(hashedUserId) {
        const regToken = `^[${token}]+$`;
        const regExp = new RegExp(regToken, 'g');

        assert(regExp.test(hashedUserId), 400, 'User id contains invalid characters', 'UIC');
    }

    hasAccessForGetUserCertificates(exams) {
        this.authorizationRequired();

        exams.forEach(exam => {
            assert.isSlug(exam, 400, 'Exam slug contains invalid characters', 'EIC', { exam });
        });
    }
}

module.exports = CertificateAccessControl;
