'use strict';

const assert = require('helpers/assert');

class IdmAccessControl {
    constructor(request, state) {
        this._hostname = request.hostname;
        this._tvmClient = state.tvmClient;
    }

    hasAccess() {
        const isYandexTeam = /.*\.yandex-team\.ru$/i.test(this._hostname);

        assert(isYandexTeam, 403, 'Application should locate on yandex-team.ru domain', 'YTD', {
            hostname: this._hostname
        });

        assert(this._tvmClient === 'idm', 403, 'Client has no access', 'CNA', { tvmClient: this._tvmClient });
    }
}

module.exports = IdmAccessControl;
