const koa = require('koa');

const requestId = require('request-id');
const responseTime = require('koa-response-time');
const bodyParser = require('koa-bodyparser');

const mount = require('koa-mount');
const log = require('logger');
const statusCodes = require('http').STATUS_CODES;
const _ = require('lodash');

const app = koa();

app.proxy = true;
app.use(bodyParser());
app.use(function *(next) {
    try {
        yield next;
    } catch (err) {
        log.error({ err, req: this, res: this });

        this.res._headers = {};

        this.status = statusCodes[err.status] ? err.status : 500;
        const message = err.expose ? err.message : statusCodes[err.status];
        const body = { message };

        if (err.options) {
            _.assign(body, err.options);
        }

        this.body = body;
    }
    log.info({ req: this, res: this });
});
app.use(responseTime());
app.use(requestId());
app.use(mount('/v1', require('web')));
app.use(mount('/web', require('web')));
app.use(mount('/telegram', require('telegram')));

module.exports = app;
