module.exports = {
    achievements: {
        shim: '3189/share_shim',
        hello: '3702/hello_share',
        direct: '3702/direct_cert_preview'
    },

    blackbox: {
        connection: {
            api: 'blackbox-mimino.yandex.net'
        }
    },

    mdsService: {
        write: {
            hostname: 'storage-int.mdst.yandex.net'
        },
        read: {
            hostname: 'storage.mdst.yandex.net'
        }
    },

    avatarsService: {
        write: {
            hostname: 'avatars-int.mdst.yandex.net'
        },
        read: {
            hostname: 'avatars.mdst.yandex.net'
        }
    },

    freezing: {
        accessLogins: ['test1', 'test2']
    },

    warnLogTimeout: 50,

    skipTokenCheck: true,

    authToken: '1234567890asdfgh',

    yt: {
        path: '//home/expert/development',
        tableCapacity: 2
    },

    proctoring: {
        pendingRange: {
            from: 50,
            to: 80
        },
        maxLimitViolation: 30,
        minVideoDuration: 15000, // 15 секунд
        maxTechMetricsViolation: 90
    },

    s3: {
        maxTrialsToUpload: 2,
        endpoint: 'https://test.host.to.s3.net'
    },

    skipTvmCheck: true,

    tvm: {
        src: 2001462,
        direct: {
            alias: 'direct-api-testing',
            dsts: 2000693
        },
        blackbox: {
            alias: 'blackbox',
            dsts: 224
        },
        yandexTeamBlackbox: {
            alias: 'blackbox-ya-team',
            dsts: 223
        }
    },

    sender: {
        host: 'https://test.host.sender.ru',
        user: 'expert',
        mailIds: {
            correct: 'CORRECT-ID',
            failed: 'FAILED-ID',
            nullifyCert: 'NULLIFY-CERT-ID',
            banCert: 'BAN-CERT'
        }
    },

    self: {
        host: 'test-host.ru'
    },

    minSpamKarma: 85,

    officeUrl: 'https://expert-office-development.yandex-team.ru',

    tracker: {
        options: {
            token: 'ST_EXAMPLE_TOKEN'
        }
    },

    comdepReport: {
        chunkSize: 2
    },

    geoadv: {
        exams: ['msp', 'direct']
    }
};
