const fs = require('fs');

module.exports = {
    clientId: 'expert-api-production',

    achievements: {
        shim: '117777/shim_share',
        hello: '102980/hello_share',
        direct: '1531713/direct_cert_preview'
    },

    blackbox: {
        connection: {
            api: 'blackbox.yandex.net'
        }
    },

    mdsService: {
        write: {
            hostname: 'storage-int.mds.yandex.net'
        },
        read: {
            hostname: 'storage.mds.yandex.net'
        }
    },

    avatarsService: {
        write: {
            hostname: 'avatars-int.mds.yandex.net'
        },
        read: {
            hostname: 'avatars.mds.yandex.net'
        }
    },

    direct: {
        url: 'http://intapi.direct.yandex.ru/UserRole'
    },

    mailLists: {
        agencies: {
            to: 'adv-expert-agency@yandex-team.ru'
        },
        draftForModeration: {
            to: 'comdeptest-bugs@yandex-team.ru'
        }
    },

    freezing: {
        to: 'expert-dev@yandex-team.ru'
    },

    skipTokenCheck: false,

    postgres: {
        options: {
            dialectOptions: {
                ssl: {
                    ca: fs.readFileSync('/root/.postgresql/root.crt').toString(),
                    sslmode: 'verify-full'
                },
                keepAlive: true
            }
        }
    },

    yt: {
        path: '//home/expert/production',
        fail: {
            to: 'expert-dev@yandex-team.ru'
        }
    },

    s3: {
        fail: {
            to: 'expert-dev@yandex-team.ru'
        },
        env: 'production'
    },

    proctoring: {
        host: 'https://yandex.proctoring.online',
        fail: {
            to: 'expert-dev@yandex-team.ru'
        }
    },

    tvm: {
        src: 2001476,
        direct: {
            alias: 'direct-api-production',
            dsts: 2000390
        },
        geoadv: {
            alias: 'geoadv-production',
            dsts: 2000731
        }
    },

    sender: {
        host: 'https://sender.yandex-team.ru',
        mailIds: {
            correct: '08TOT703-RCW',
            failed: '4L8CU703-KVZ1',
            nullifyCert: 'CDXXBL43-OPP',
            banCert: '0UW8A6B3-0QZ1'
        }
    },

    self: {
        host: 'expert-api.commerce-int.yandex.ru'
    },

    officeUrl: 'https://expert-office.yandex-team.ru',

    certServices: [
        'market',
        'metrika',
        'direct_en',
        'direct_cn',
        'metrika_en',
        'rsya',
        'publisher',
        'direct_pro',
        'cpm',
        'zen',
        'msp'
    ],

    tracker: {
        options: {
            endpoint: 'https://st-api.yandex-team.ru/v2'
        },
        followers: ['simani', 'linazk', 's-udalov'],
        fail: {
            to: 'expert-dev@yandex-team.ru'
        }
    },

    geoadv: {
        host: 'https://api-geoadv.maps.yandex.net',
        fail: {
            to: 'expert-dev@yandex-team.ru'
        }
    }
};
