const fs = require('fs');

module.exports = {
    achievements: {
        shim: '3189/share_shim',
        hello: '3702/hello_share',
        direct: '3702/direct_cert_preview'
    },

    blackbox: {
        connection: {
            api: 'pass-stress-i1.sezam.yandex.net'
        }
    },

    mdsService: {
        write: {
            hostname: 'storage-int.mdst.yandex.net'
        },
        read: {
            hostname: 'storage.mdst.yandex.net'
        }
    },

    avatarsService: {
        write: {
            hostname: 'avatars-int.mdst.yandex.net'
        },
        read: {
            hostname: 'avatars.mdst.yandex.net'
        }
    },

    postgres: {
        options: {
            dialectOptions: {
                ssl: {
                    ca: fs.readFileSync('/root/.postgresql/root.crt').toString(),
                    sslmode: 'verify-full'
                },
                keepAlive: true
            },
            pool: {
                max: 400
            }
        }
    },

    yt: {
        path: '//home/expert/development'
    },

    skipTvmCheck: true,

    tvm: {
        src: 2001462,
        direct: {
            alias: 'direct-api-testing',
            dsts: 2000693
        }
    },

    tracker: {
        options: {
            token: 'ST_EXAMPLE_TOKEN'
        }
    }
};
