module.exports = function (sequelize, DataTypes) {
    return sequelize.define('adminsToRoles', {
        id: {
            type: DataTypes.INTEGER,
            allowNull: false,
            autoIncrement: true,
            primaryKey: true
        },
        adminId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            unique: 'unique_constr',
            field: 'admin_id'
        },
        roleId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            unique: 'unique_constr',
            field: 'role_id'
        }
    }, {
        timestamps: false,
        freezeTableName: true,
        tableName: 'admins_to_roles',
        underscored: true,
        indexes: [
            {
                name: 'role_idx',
                fields: ['role_id']
            }
        ]
    });
};
