module.exports = function (sequelize, DataTypes) {
    return sequelize.define('agencies', {
        id: {
            type: DataTypes.INTEGER,
            allowNull: false,
            autoIncrement: true,
            primaryKey: true
        },
        login: {
            type: DataTypes.STRING,
            allowNull: false
        },
        title: {
            type: DataTypes.STRING,
            allowNull: false
        },
        manager: {
            type: DataTypes.STRING,
            allowNull: false
        },
        directId: {
            type: DataTypes.BIGINT,
            allowNull: false,
            field: 'direct_id'
        }
    }, {
        timestamps: false,
        freezeTableName: true,
        tableName: 'agencies',
        underscored: true
    });
};
