module.exports = function (sequelize, DataTypes) {
    return sequelize.define('answer', {
        id: {
            type: DataTypes.INTEGER,
            allowNull: false,
            autoIncrement: true,
            primaryKey: true
        },
        questionId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'question_id'
        },
        questionVersion: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'question_version'
        },
        correct: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        text: {
            type: DataTypes.TEXT,
            allowNull: false
        },
        active: {
            type: DataTypes.INTEGER,
            allowNull: false,
            defaultValue: 1
        }
    }, {
        timestamps: false,
        freezeTableName: true,
        tableName: 'answers',
        underscored: true,
        indexes: [
            {
                name: 'question_id',
                fields: ['question_id']
            }
        ]
    });
};
