module.exports = function (sequelize, DataTypes) {
    return sequelize.define('ban', {
        id: {
            type: DataTypes.INTEGER,
            allowNull: false,
            autoIncrement: true,
            primaryKey: true
        },
        globalUserId: {
            type: DataTypes.BIGINT,
            allowNull: false,
            field: 'global_user_id'
        },
        adminId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'admin_id'
        },
        action: {
            type: DataTypes.ENUM('ban', 'unban'),
            allowNull: false
        },
        trialTemplateId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'trial_template_id'
        },
        startedDate: {
            type: DataTypes.DATE,
            allowNull: false,
            field: 'started_date'
        },
        expiredDate: {
            type: DataTypes.DATE,
            allowNull: true,
            field: 'expired_date'
        },
        reason: {
            type: DataTypes.TEXT,
            allowNull: true
        },
        userLogin: {
            type: DataTypes.STRING,
            allowNull: false,
            field: 'user_login'
        },
        isLast: {
            type: DataTypes.BOOLEAN,
            allowNull: false,
            field: 'is_last',
            defaultValue: false
        }
    }, {
        timestamps: false,
        freezeTableName: true,
        tableName: 'bans',
        underscored: true,
        indexes: [
            {
                name: 'bans_global_user_id_idx',
                fields: ['global_user_id']
            }
        ]
    });
};
