module.exports = function (sequelize, DataTypes) {
    return sequelize.define('certificate', {
        id: {
            type: DataTypes.INTEGER,
            allowNull: false,
            autoIncrement: true,
            primaryKey: true
        },
        trialId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'trial_id'
        },
        firstname: {
            type: DataTypes.STRING,
            allowNull: true
        },
        lastname: {
            type: DataTypes.STRING,
            allowNull: true
        },
        dueDate: {
            type: DataTypes.DATE,
            allowNull: false,
            field: 'due_date'
        },
        confirmed: {
            type: DataTypes.INTEGER,
            allowNull: false,
            defaultValue: 0
        },
        confirmedDate: {
            type: DataTypes.DATE,
            allowNull: true,
            field: 'confirmed_date'
        },
        active: {
            type: DataTypes.INTEGER,
            allowNull: false,
            defaultValue: 0
        },
        imagePath: {
            type: DataTypes.STRING,
            allowNull: true,
            field: 'image_path'
        },
        pdfPath: {
            type: DataTypes.STRING,
            allowNull: true,
            field: 'pdf_path'
        },
        typeId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'type_id'
        },
        deactivateReason: {
            type: DataTypes.ENUM('ban', 'rules'),
            allowNull: true,
            field: 'deactivate_reason'
        },
        deactivateDate: {
            type: DataTypes.DATE,
            allowNull: true,
            field: 'deactivate_date'
        },
        isSentToGeoadv: {
            type: DataTypes.BOOLEAN,
            defaultValue: false,
            allowNull: false,
            field: 'is_sent_to_geoadv'
        }
    }, {
        timestamps: false,
        freezeTableName: true,
        tableName: 'certificates',
        underscored: true,
        indexes: [
            {
                name: 'trial_id_idx',
                fields: ['trial_id']
            }
        ]
    });
};
