module.exports = function (sequelize, DataTypes) {
    return sequelize.define('draft', {
        id: {
            type: DataTypes.INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true
        },
        trialTemplateId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'trial_template_id'
        },
        adminId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'admin_id'
        },
        exam: {
            type: DataTypes.JSON,
            allowNull: false
        },
        saveDate: {
            type: DataTypes.DATE,
            field: 'save_date',
            allowNull: false
        },
        status: {
            type: DataTypes.ENUM('saved', 'on_moderation', 'published', 'ignored'),
            allowNull: false
        }
    }, {
        timestamps: false,
        freezeTableName: true,
        tableName: 'drafts',
        underscored: true
    });
};
