module.exports = function (sequelize, DataTypes) {
    return sequelize.define('freezing', {
        id: {
            type: DataTypes.INTEGER,
            allowNull: false,
            autoIncrement: true,
            primaryKey: true
        },
        frozenBy: {
            type: DataTypes.BIGINT,
            allowNull: false,
            field: 'frozen_by'
        },
        unfrozenBy: {
            type: DataTypes.BIGINT,
            allowNull: true,
            field: 'unfrozen_by'
        },
        startTime: {
            type: DataTypes.DATE,
            allowNull: false,
            field: 'start_time'
        },
        finishTime: {
            type: DataTypes.DATE,
            allowNull: false,
            field: 'finish_time'
        },
        trialTemplateId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'trial_template_id'
        }
    }, {
        timestamps: false,
        freezeTableName: true,
        tableName: 'freezing',
        underscored: true
    });
};
