module.exports = function (sequelize, DataTypes) {
    return sequelize.define('global_user', {
        id: {
            type: DataTypes.BIGINT,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true
        },
        actualLogin: {
            type: DataTypes.STRING,
            allowNull: false,
            field: 'actual_login',
            unique: true
        },
        isBanned: {
            type: DataTypes.BOOLEAN,
            allowNull: false,
            field: 'is_banned',
            defaultValue: false
        },
        isActive: {
            type: DataTypes.BOOLEAN,
            allowNull: false,
            field: 'is_active',
            defaultValue: true
        }
    }, {
        timestamps: false,
        freezeTableName: true,
        tableName: 'global_users',
        underscored: true
    });
};
