module.exports = function (sequelize, DataTypes) {
    return sequelize.define('lock', {
        id: {
            type: DataTypes.INTEGER,
            allowNull: false,
            autoIncrement: true,
            primaryKey: true
        },
        trialTemplateId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'trial_template_id'
        },
        adminId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'admin_id'
        },
        lockDate: {
            type: DataTypes.DATE,
            allowNull: false,
            field: 'lock_date'
        },
        unlockDate: {
            type: DataTypes.DATE,
            allowNull: true,
            field: 'unlock_date'
        }
    }, {
        timestamps: false,
        freezeTableName: true,
        tableName: 'locks',
        underscored: true
    });
};
