module.exports = function (sequelize, DataTypes) {
    return sequelize.define('proctoring_response', {
        id: {
            type: DataTypes.BIGINT,
            allowNull: false,
            autoIncrement: true,
            primaryKey: true
        },
        trialId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'trial_id'
        },
        source: {
            type: DataTypes.ENUM('proctoring', 'toloka', 'toloka-revision', 'appeal', 'metrics', 'crit-metrics'),
            allowNull: false
        },
        verdict: {
            type: DataTypes.ENUM('failed', 'pending', 'correct'),
            allowNull: false
        },
        evaluation: {
            type: DataTypes.INTEGER,
            allowNull: true
        },
        time: {
            type: DataTypes.DATE,
            allowNull: false
        },
        isLast: {
            type: DataTypes.BOOLEAN,
            allowNull: false,
            field: 'is_last'
        },
        isSentToToloka: {
            type: DataTypes.BOOLEAN,
            defaultValue: false,
            allowNull: false,
            field: 'is_sent_to_toloka'
        },
        isRevisionRequested: {
            type: DataTypes.BOOLEAN,
            defaultValue: false,
            allowNull: false,
            field: 'is_revision_requested'
        },
        additionalInfo: {
            type: DataTypes.JSONB,
            allowNull: true,
            field: 'additional_info'
        }
    }, {
        timestamps: false,
        freezeTableName: true,
        tableName: 'proctoring_responses',
        underscored: true,
        indexes: [
            {
                name: 'proctoring_responses_trial_id_idx',
                fields: ['trial_id']
            }
        ],
        instanceMethods: {
            isCorrect() {
                return this.verdict === 'correct';
            },
            isPending() {
                return this.verdict === 'pending';
            },
            isFailed() {
                return this.verdict === 'failed';
            }
        }
    });
};
