module.exports = function (sequelize, DataTypes) {
    return sequelize.define('proctoring_video', {
        id: {
            type: DataTypes.INTEGER,
            allowNull: false,
            autoIncrement: true,
            primaryKey: true
        },
        trialId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'trial_id'
        },
        name: {
            type: DataTypes.STRING,
            allowNull: false
        },
        startTime: {
            type: DataTypes.BIGINT,
            allowNull: false,
            field: 'start_time'
        },
        duration: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        source: {
            type: DataTypes.ENUM('webcam', 'screen'),
            allowNull: false
        }
    }, {
        timestamps: false,
        freezeTableName: true,
        tableName: 'proctoring_videos',
        underscored: true,
        indexes: [
            {
                name: 'proctoring_videos_trial_id_name_unique',
                unique: true,
                fields: ['trial_id', 'name']
            }
        ]
    });
};
