module.exports = function (sequelize, DataTypes) {
    return sequelize.define('question', {
        id: {
            type: DataTypes.INTEGER,
            allowNull: false,
            autoIncrement: true,
            primaryKey: true
        },
        version: {
            type: DataTypes.INTEGER,
            allowNull: false,
            defaultValue: 0,
            primaryKey: true
        },
        active: {
            type: DataTypes.INTEGER,
            allowNull: false,
            defaultValue: 1
        },
        archived: {
            type: DataTypes.INTEGER,
            allowNull: false,
            defaultValue: 0
        },
        sectionId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'section_id'
        },
        categoryId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'category_id'
        },
        text: {
            type: DataTypes.TEXT,
            allowNull: false
        },
        type: {
            type: DataTypes.INTEGER,
            allowNull: false,
            defaultValue: 0
        }
    }, {
        timestamps: false,
        freezeTableName: true,
        tableName: 'questions',
        underscored: true,
        indexes: [
            {
                name: 'category_idx',
                fields: ['category_id']
            },
            {
                name: 'section_idx',
                fields: ['section_id']
            }
        ]
    });
};
