module.exports = function (sequelize, DataTypes) {
    return sequelize.define('section', {
        id: {
            type: DataTypes.INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true
        },
        serviceId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            unique: 'unique_constr',
            field: 'service_id'
        },
        code: {
            type: DataTypes.STRING,
            allowNull: false,
            unique: 'unique_constr'
        },
        title: {
            type: DataTypes.STRING,
            allowNull: false
        }
    }, {
        timestamps: false,
        freezeTableName: true,
        tableName: 'sections',
        underscored: true,
        indexes: [
            {
                name: 'section_code_idx',
                fields: ['code']
            }
        ]
    });
};
