module.exports = function (sequelize, DataTypes) {
    return sequelize.define('service', {
        id: {
            type: DataTypes.INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true
        },
        code: {
            type: DataTypes.STRING,
            allowNull: false
        },
        title: {
            type: DataTypes.STRING,
            allowNull: false
        }
    }, {
        timestamps: false,
        freezeTableName: true,
        tableName: 'services',
        underscored: true,
        indexes: [
            {
                name: 'service_code_idx',
                fields: ['code']
            }
        ]
    });
};
