const config = require('yandex-config');

module.exports = function (sequelize, DataTypes) {
    return sequelize.define('trial_template', {
        id: {
            type: DataTypes.INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true
        },
        active: {
            type: DataTypes.INTEGER,
            allowNull: false,
            defaultValue: 0
        },
        serviceId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'service_id'
        },
        language: {
            type: DataTypes.INTEGER,
            allowNull: false,
            get() {
                const lang = this.getDataValue('language');

                return config.i18n.languages[lang] || config.i18n.defaultLanguage;
            }
        },
        typeId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'type_id'
        },
        title: {
            type: DataTypes.STRING,
            allowNull: false
        },
        description: {
            type: DataTypes.TEXT,
            allowNull: false
        },
        rules: {
            type: DataTypes.TEXT,
            allowNull: false
        },
        seoDescription: {
            type: DataTypes.TEXT,
            allowNull: false,
            field: 'seo_description'
        },
        ogDescription: {
            type: DataTypes.TEXT,
            allowNull: false,
            field: 'og_description'
        },
        previewCert: {
            type: DataTypes.TEXT,
            field: 'preview_cert',
            allowNull: false
        },
        allowedTriesCount: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'allowed_tries_count'
        },
        timeLimit: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'time_limit'
        },
        allowedFails: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'allowed_fails'
        },
        delays: {
            type: DataTypes.STRING,
            get() {
                const delays = this.getDataValue('delays');

                return delays ? delays.replace(/\s/g, '').split(',') : [];
            },
            allowNull: false
        },
        validityPeriod: {
            type: DataTypes.STRING,
            allowNull: false,
            field: 'validity_period'
        },
        periodBeforeCertificateReset: {
            type: DataTypes.STRING,
            allowNull: false,
            field: 'period_before_certificate_reset'
        },
        delayUntilTrialsReset: {
            type: DataTypes.STRING,
            allowNull: false,
            field: 'delay_until_trials_reset'
        },
        slug: {
            type: DataTypes.STRING,
            allowNull: false,
            defaultValue: ''
        },
        previewImagePath: {
            type: DataTypes.STRING,
            allowNull: true,
            field: 'preview_image_path'
        },
        isProctoring: {
            type: DataTypes.BOOLEAN,
            allowNull: false,
            field: 'is_proctoring',
            defaultValue: false
        },
        clusterSlug: {
            type: DataTypes.STRING,
            allowNull: false,
            field: 'cluster_slug'
        }
    }, {
        timestamps: false,
        freezeTableName: true,
        tableName: 'trial_templates',
        underscored: true,
        indexes: [
            {
                name: 'trial_templates_type_id_idx',
                fields: ['type_id']
            },
            {
                name: 'trial_templates_service_id_idx',
                fields: ['service_id']
            }
        ]
    });
};
