module.exports = function (sequelize, DataTypes) {
    return sequelize.define('trial_template_allowed_fails', {
        id: {
            type: DataTypes.INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true
        },
        trialTemplateId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            unique: 'unique_constr',
            field: 'trial_template_id'
        },
        sectionId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            unique: 'unique_constr',
            field: 'section_id'
        },
        allowedFails: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'allowed_fails',
            defaultValue: 0
        }
    }, {
        timestamps: false,
        freezeTableName: true,
        tableName: 'trial_template_allowed_fails',
        underscored: true,
        indexes: [
            {
                name: 'section_id_idx',
                fields: ['section_id']
            }
        ]
    });
};
