module.exports = function (sequelize, DataTypes) {
    return sequelize.define('trial_template_to_section', {
        id: {
            type: DataTypes.INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true
        },
        trialTemplateId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            unique: 'unique_constr',
            field: 'trial_template_id'
        },
        sectionId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            unique: 'unique_constr',
            field: 'section_id'
        },
        categoryId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            unique: 'unique_constr',
            field: 'category_id'
        },
        quantity: {
            type: DataTypes.INTEGER,
            allowNull: false
        }
    }, {
        timestamps: false,
        freezeTableName: true,
        tableName: 'trial_templates_to_sections',
        underscored: true,
        indexes: [
            {
                name: 'trial_templates_to_sections_section_id_idx',
                fields: ['section_id']
            },
            {
                name: 'trial_templates_to_sections_category_id_idx',
                fields: ['category_id']
            }
        ]
    });
};
