module.exports = function (sequelize, DataTypes) {
    return sequelize.define('trial_to_question', {
        trialId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'trial_id',
            primaryKey: true
        },
        seq: {
            type: DataTypes.INTEGER,
            allowNull: false,
            primaryKey: true
        },
        questionId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'question_id'
        },
        questionVersion: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'question_version'
        },
        answered: {
            type: DataTypes.INTEGER,
            allowNull: false,
            defaultValue: 0
        },
        correct: {
            type: DataTypes.INTEGER,
            allowNull: false,
            defaultValue: 0
        }
    }, {
        timestamps: false,
        freezeTableName: true,
        tableName: 'trials_to_questions',
        underscored: true,
        indexes: [
            {
                name: 'trial_and_question_idx',
                fields: ['trial_id', 'question_id', 'answered']
            },
            {
                name: 'trials_to_questions_question_id_idx',
                fields: ['question_id']
            }
        ]
    });
};
