module.exports = function (sequelize, DataTypes) {
    return sequelize.define('type', {
        id: {
            type: DataTypes.INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true
        },
        code: {
            type: DataTypes.STRING,
            allowNull: false
        },
        title: {
            type: DataTypes.STRING,
            allowNull: false
        }
    }, {
        timestamps: false,
        freezeTableName: true,
        tableName: 'types',
        underscored: true,
        indexes: [
            {
                name: 'type_code_idx',
                fields: ['code']
            }
        ]
    });
};
