module.exports = function (sequelize, DataTypes) {
    return sequelize.define('user', {
        id: {
            type: DataTypes.BIGINT,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true
        },
        login: {
            type: DataTypes.STRING,
            allowNull: true
        },
        firstname: {
            type: DataTypes.STRING,
            allowNull: true
        },
        lastname: {
            type: DataTypes.STRING,
            allowNull: true
        },
        roleId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'role_id'
        },
        agencyId: {
            type: DataTypes.INTEGER,
            allowNull: true,
            field: 'agency_id'
        },
        yandexUid: {
            type: DataTypes.BIGINT,
            allowNull: true,
            field: 'yandex_uid'
        },
        uid: {
            type: DataTypes.BIGINT,
            allowNull: false,
            unique: 'idx_users_uid_auth_type_id'
        },
        authTypeId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'auth_type_id',
            unique: 'idx_users_uid_auth_type_id'
        },
        email: {
            type: DataTypes.STRING,
            allowNull: true
        },
        globalUserId: {
            type: DataTypes.BIGINT,
            allowNull: true,
            field: 'global_user_id'
        }
    }, {
        timestamps: false,
        freezeTableName: true,
        tableName: 'users',
        underscored: true,
        indexes: [
            {
                name: 'users_role_id_idx',
                fields: ['role_id']
            },
            {
                name: 'users_agency_id_idx',
                fields: ['agency_id']
            },
            {
                name: 'users_auth_type_id_idx',
                fields: ['auth_type_id']
            }
        ]
    });
};
