module.exports = function (sequelize, DataTypes) {
    return sequelize.define('user_identification', {
        id: {
            type: DataTypes.INTEGER,
            allowNull: false,
            autoIncrement: true,
            primaryKey: true
        },
        userId: {
            type: DataTypes.BIGINT,
            allowNull: false,
            field: 'user_id'
        },
        trialTemplateId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            field: 'trial_template_id'
        },
        document: {
            type: DataTypes.STRING,
            allowNull: false
        },
        face: {
            type: DataTypes.STRING,
            allowNull: false
        }
    }, {
        timestamps: true,
        freezeTableName: true,
        tableName: 'user_identifications',
        underscored: true,
        indexes: [
            {
                name: 'user_identification_idx',
                fields: ['user_id', 'trial_template_id']
            }
        ]
    });
};
