require('pg').defaults.parseInt8 = true;

const config = require('yandex-config');
const Sequelize = require('sequelize');

const sequelize = new Sequelize(config.postgres.uri, config.postgres.options);

const Question = sequelize.import('entities/question');
const Section = sequelize.import('entities/section');
const Service = sequelize.import('entities/service');
const Trial = sequelize.import('entities/trial');
const TrialTemplate = sequelize.import('entities/trialTemplate');
const Type = sequelize.import('entities/type');
const TrialTemplateToSection = sequelize.import('entities/trialTemplateToSection');
const TrialToQuestion = sequelize.import('entities/trialToQuestion');
const Certificate = sequelize.import('entities/certificate');
const Answer = sequelize.import('entities/answer');
const User = sequelize.import('entities/user');
const TrialTemplateAllowedFails = sequelize.import('entities/trialTemplateAllowedFails');
const Category = sequelize.import('entities/category');
const Role = sequelize.import('entities/role');
const Agency = sequelize.import('entities/agency');
const DirectSync = sequelize.import('entities/directSync');
const AuthType = sequelize.import('entities/authType');
const Freezing = sequelize.import('entities/freezing');
const Admin = sequelize.import('entities/admin');
const AdminToRole = sequelize.import('entities/adminToRole');
const UserIdentification = sequelize.import('entities/userIdentification');
const ProctoringResponses = sequelize.import('entities/proctoringResponses');
const ProctoringVideos = sequelize.import('entities/proctoringVideos');
const TvmClient = sequelize.import('entities/tvmClient');
const Draft = sequelize.import('entities/draft');
const Lock = sequelize.import('entities/lock');
const Ban = sequelize.import('entities/ban');
const GlobalUser = sequelize.import('entities/globalUser');

TrialToQuestion.removeAttribute('id');
TvmClient.removeAttribute('id');

Trial.belongsTo(TrialTemplate, { as: 'trialTemplate' });
Trial.belongsTo(User);
Trial.hasMany(Certificate, { as: 'certificates' });
Trial.hasMany(TrialToQuestion, { as: 'questions' });
Trial.hasMany(ProctoringResponses, { as: 'proctoringResponses' });
Trial.hasMany(ProctoringVideos, { as: 'proctoringVideos' });

TrialTemplate.hasMany(Trial);
TrialTemplate.belongsTo(Type);
TrialTemplate.belongsTo(Service);
TrialTemplate.hasMany(TrialTemplateToSection, { as: 'sections' });
TrialTemplate.hasMany(TrialTemplateToSection, { as: 'trialTemplateToSection' });
TrialTemplate.hasMany(TrialTemplateAllowedFails, { as: 'trialTemplateAllowedFails' });
TrialTemplate.hasMany(Freezing);
TrialTemplate.hasMany(Draft, { as: 'drafts' });
TrialTemplate.hasMany(Ban, { as: 'bans' });

TrialTemplateToSection.belongsTo(Section);
TrialTemplateToSection.belongsTo(TrialTemplate);

Section.hasMany(TrialTemplateToSection, { as: 'trialTemplateToSections' });
Section.hasMany(TrialTemplateAllowedFails, { as: 'trialTemplateAllowedFails' });
Section.hasMany(Question, { as: 'questions' });

TrialToQuestion.belongsTo(Question, {
    foreignKey: 'question_id',
    targetKey: 'id',
    scope: { version: { $col: 'trial_to_question.question_version' } }
});
TrialToQuestion.belongsTo(Trial);

Question.belongsTo(Section);
Question.hasMany(Answer, {
    as: 'answers',
    foreignKey: 'question_id',
    sourceKey: 'id',
    scope: { 'question_version': { $col: 'version' } }
});
Question.hasMany(TrialToQuestion, {
    as: 'trialToQuestions',
    foreignKey: 'question_id',
    sourceKey: 'id',
    scope: { 'question_version': { $col: 'version' } }
});

Certificate.belongsTo(Trial);
Certificate.belongsTo(Type);

TrialTemplateAllowedFails.belongsTo(TrialTemplate);
TrialTemplateAllowedFails.belongsTo(Section);

User.belongsTo(Role);
User.belongsTo(Agency);
User.belongsTo(AuthType, { as: 'authType' });
User.hasMany(Trial, { as: 'trials' });

Answer.belongsTo(Question, {
    foreignKey: 'question_id',
    targetKey: 'id',
    scope: { version: { $col: 'answer.question_version' } }
});

Admin.hasMany(AdminToRole, { as: 'adminToRoles' });

AdminToRole.belongsTo(Role);
AdminToRole.belongsTo(Admin);

User.hasMany(UserIdentification, { as: 'userIdentifications' });
TrialTemplate.hasMany(UserIdentification, { as: 'userIdentifications' });

ProctoringResponses.belongsTo(Trial, { as: 'trial' });

ProctoringVideos.belongsTo(Trial, { as: 'trial' });

Lock.belongsTo(Admin);
Lock.belongsTo(TrialTemplate, { as: 'trialTemplate' });

Ban.belongsTo(TrialTemplate, { as: 'trialTemplate' });
Ban.belongsTo(Admin);

GlobalUser.hasMany(Ban, { as: 'bans' });
GlobalUser.hasMany(User, { as: 'users' });

module.exports.sequelize = sequelize;
module.exports.Question = Question;
module.exports.Section = Section;
module.exports.Service = Service;
module.exports.Trial = Trial;
module.exports.TrialTemplate = TrialTemplate;
module.exports.Type = Type;
module.exports.TrialTemplateToSection = TrialTemplateToSection;
module.exports.TrialToQuestion = TrialToQuestion;
module.exports.Certificate = Certificate;
module.exports.Answer = Answer;
module.exports.User = User;
module.exports.TrialTemplateAllowedFails = TrialTemplateAllowedFails;
module.exports.Category = Category;
module.exports.Role = Role;
module.exports.Agency = Agency;
module.exports.DirectSync = DirectSync;
module.exports.Freezing = Freezing;
module.exports.AuthType = AuthType;
module.exports.Admin = Admin;
module.exports.AdminToRole = AdminToRole;
module.exports.UserIdentification = UserIdentification;
module.exports.ProctoringResponses = ProctoringResponses;
module.exports.ProctoringVideos = ProctoringVideos;
module.exports.TvmClient = TvmClient;
module.exports.Draft = Draft;
module.exports.Lock = Lock;
module.exports.Ban = Ban;
module.exports.GlobalUser = GlobalUser;
