const assert = require('http-assert');

const schemaValidator = require('helpers/schema');

// eslint-disable-next-line max-params
function httpAssert(value, code, message, shortMessage, options) {
    options = options || {};

    if (shortMessage) {
        options.internalCode = `${code}_${shortMessage}`;
    }

    assert(value, code, message, { options });
}

module.exports = httpAssert;

// eslint-disable-next-line max-params
module.exports.isNumber = function (value, code, message, shortMessage, options) {
    httpAssert(/^\d+$/.test(value), code, message, shortMessage, options);
};

// eslint-disable-next-line max-params
module.exports.isSlug = function (value, code, message, shortMessage, options) {
    httpAssert(/^[a-z0-9_-]+$/i.test(value), code, message, shortMessage, options);
};

// eslint-disable-next-line max-params
module.exports.isOpenId = function (value, code, message, shortMessage, options) {
    httpAssert(/^[a-z\d]{8}(?:-[a-z\d]{4}){3}-[a-z\d]{12}$/.test(value), code, message, shortMessage, options);
};

// eslint-disable-next-line max-params
module.exports.isValidEmail = function (value, code, message, shortMessage, options) {
    httpAssert(/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(value), code, message, shortMessage, options);
};

module.exports.bySchema = (value, schemaName) => {
    const isValid = schemaValidator.validate(schemaName, value);
    const errors = isValid ? null : schemaValidator.errors.slice();

    httpAssert(isValid, 400, `${schemaName} check by schema failed`, 'CSF', { errors });
};

// eslint-disable-next-line max-params
module.exports.isBoolean = function (value, code, message, shortMessage, options) {
    httpAssert(typeof value === 'boolean', code, message, shortMessage, options);
};
