const moment = require('moment');

const DATETIME_SHORTHAND = {
    d: 'days',
    w: 'weeks',
    m: 'months',
    y: 'years'
};

function isValidInterval(str) {
    return /^\d+[dwmy]$/i.test(str);
}

function getMeasure(str) {
    return DATETIME_SHORTHAND[str[str.length - 1].toLowerCase()];
}

function changeDate(method, beginDate, str) {
    if (!isValidInterval(str)) {
        return beginDate;
    }

    const measure = getMeasure(str);
    const count = parseInt(str, 10);

    return moment(beginDate)[method](count, measure).startOf('day').toDate();
}

function getPrevMonthInterval(date) {
    const dateAtPrevMonth = moment(date).subtract(1, 'month');
    const from = moment(dateAtPrevMonth).startOf('month').toDate();
    const to = moment(dateAtPrevMonth).endOf('month').toDate();

    return { from, to };
}

module.exports = {
    isValidInterval,
    subtractFromDate: changeDate.bind(null, 'subtract'),
    addToDate: changeDate.bind(null, 'add'),
    getMeasure,
    getPrevMonthInterval
};
