const _ = require('lodash');

const UserModel = require('models/user');
const BanModel = require('models/ban');
const GlobalUserModel = require('models/globalUser');

module.exports = function *getBanData(examIdentity, userData, transaction) {
    const User = new UserModel(userData.authTypeCode);
    const user = yield User.findUser({
        where: { uid: userData.uid },
        attributes: ['globalUserId'],
        transaction
    });
    const { globalUserId } = user || {};

    let globalUser;
    let lastBan;

    if (globalUserId) {
        [globalUser, lastBan] = yield [
            GlobalUserModel.findById({ id: globalUserId, attributes: ['isBanned', 'actualLogin'] }, transaction),
            BanModel.findLastBan(globalUserId, examIdentity, transaction)
        ];
    }

    const expiredDate = _.get(lastBan, 'expiredDate');
    const isBannedOnTest = expiredDate > new Date();

    return {
        isBannedOnTest,
        isSuperBanned: _.get(globalUser, 'isBanned', false),
        actualLogin: _.get(globalUser, 'actualLogin', ''),
        expiredDate: isBannedOnTest ? expiredDate : null
    };
};
