const got = require('got');
const { tanker } = require('yandex-config');
const url = require('url');
const log = require('logger');
const fs = require('fs');
const path = require('path');
const options = {
    headers: {
        Authorisation: `OAuth ${process.env.TANKER_OAUTH_TOKEN}`
    }
};

const uri = url.format(tanker);

log.info(`Request to ${uri}`);

got(uri, options)
    .then(res => {
        log.info('Data were obtained from Tanker');

        const directoryPath = path.join(__dirname, '..', 'tanker');
        const filePath = path.join(directoryPath, 'i18n.cert.json');

        const data = res.body;

        fs.mkdirSync(directoryPath, { recursive: true });
        fs.writeFileSync(filePath, data);

        log.info(`Data written to a file ${filePath}`);
    }, e => {
        log.error(e);
    });
