const config = require('yandex-config').mail;
const nodemailer = require('nodemailer');
const transporter = nodemailer.createTransport({
    host: config.smtp,
    port: 25
});

/**
 * @param {Object} options - see documentation https://nodemailer.com/
 * @returns {Promise}
 */
module.exports = function (options) {
    return new Promise((resolve, reject) => {
        transporter.sendMail(options, error => {
            if (error) {
                reject();
            } else {
                resolve();
            }
        });
    });
};
